/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.browser.parts;

import com.aptana.browser.WebBrowserViewer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.ViewPart;

public class WebBrowserView
extends ViewPart {
    public static final String VIEW_ID = "com.aptana.browser.views.webbrowser";
    private WebBrowserViewer browserViewer;
    private int progressWorked;

    public void createPartControl(Composite parent) {
        this.browserViewer = new WebBrowserViewer(parent, 1);
        Browser browser = (Browser)this.browserViewer.getBrowser();
        browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
                if (event.total == 0) {
                    return;
                }
                if (event.current == 0) {
                    IProgressMonitor progressMonitor = WebBrowserView.this.getStatusBarProgressMonitor();
                    progressMonitor.done();
                    progressMonitor.beginTask("", event.total);
                    WebBrowserView.this.progressWorked = 0;
                }
                if (WebBrowserView.this.progressWorked < event.current) {
                    WebBrowserView.this.getStatusBarProgressMonitor().worked(event.current - WebBrowserView.this.progressWorked);
                    WebBrowserView.this.progressWorked = event.current;
                }
            }

            public void completed(ProgressEvent event) {
                WebBrowserView.this.getStatusBarProgressMonitor().done();
            }
        });
        browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                WebBrowserView.this.setTitleToolTip(event.title);
            }
        });
    }

    public void setFocus() {
        this.browserViewer.setFocus();
    }

    private IProgressMonitor getStatusBarProgressMonitor() {
        IStatusLineManager statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        return statusLineManager.getProgressMonitor();
    }

    public boolean close() {
        try {
            this.getSite().getPage().hideView((IViewPart)this);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setURL(String url) {
        this.browserViewer.setURL(url);
    }
}

